% Video Inpainting via Tensor Completion

clear
rng('default')
load akiyo.mat
M          = Y(:,:,1:30);
M          = M/255;
maxP       = max(abs(M(:)));
[n1,n2,n3] = size(M);
L          = dct(eye(n3));

p            = 0.5;
List         = rand(n1*n2*n3,1);
omega        = find(List<p);
Omega        = zeros(n1,n2,n3);
Iones        = ones(n1,n2,n3);
Omega(omega) = Iones(omega);
Data         = Omega.*M;

% a grayscale video is an approximately low-rank tensor 
% but not a strictly low-rank tensor

opts.maxiter   = 100;
opts.lambdamax = 100;
opts.lambdamin = 1e-3;
opts.mu        = 0.99;
opts.rho       = 0.8;
opts.tau       = 10;
opts.delta     = 100;
opts.tol       = 1e-2;

tic
[X,Y,iter,out] = lrtc(M,Data,Omega,L,opts);
toc

X    = max(X,0);
X    = min(X,maxP);
psnr = psnr(M,X,maxP)


figure;
for i = 1:(size(X,3))
    subplot(221);imagesc(M(:,:,i));axis off;
    colormap(gray);title('Original Video');
    subplot(222);imagesc(Data(:,:,i)) ;axis off;
    colormap(gray);title('Sampled Video');
    subplot(224);imagesc(X(:,:,i));axis off;
    colormap(gray);title('Recovered Video');
    pause(.1);
end